/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.LocateDialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.dialogs.LocateDialog;
import net.nooj4nlp.gui.main.Launcher;

public class LocateDialogPatternActionListener
implements ActionListener {
    private JInternalFrame frame;
    private List<String> listOfFilesToBeSaved = new ArrayList<String>();
    private LocateDialog locateDialog;

    public LocateDialogPatternActionListener(JInternalFrame frame, TextEditorShellController controller, LocateDialog locateDialog) {
        this.listOfFilesToBeSaved = controller.getLocateGrammarMemoryList();
        this.frame = frame;
        this.locateDialog = locateDialog;
    }

    public LocateDialogPatternActionListener(LocateDialog locateDialog) {
        this.locateDialog = locateDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.locateDialog.getRbNooJPattern()) {
            this.locateDialog.getNooJRegeXCombo().setEnabled(true);
            this.locateDialog.getSyntacticAnalysisCBox().setSelected(false);
            this.disableGrammarComponents();
            this.enableIndexRadioButtons();
        } else if (e.getSource() == this.locateDialog.getRbNooJGrammar()) {
            this.locateDialog.getNooJRegeXCombo().setEnabled(false);
            this.enableIndexRadioButtons();
            this.enableGrammarComponents();
            if (this.locateDialog.getNooJGrammarPathCombo().getSelectedItem().toString().equals("")) {
                this.openFileChooserWindow();
            }
        } else if (e.getSource() == this.locateDialog.getSetButton()) {
            this.openFileChooserWindow();
        } else {
            this.locateDialog.getNooJRegeXCombo().setEnabled(true);
            this.locateDialog.getSyntacticAnalysisCBox().setSelected(false);
            this.disableGrammarComponents();
            this.disableIndexRadioButtons();
        }
    }

    private void openFileChooserWindow() {
        String defaultPath = Paths.docDir + System.getProperty("file.separator") + Launcher.preferences.deflanguage + System.getProperty("file.separator") + "Syntactic Analysis";
        File defaultFile = new File(defaultPath);
        FileNameExtensionFilter filterGram = new FileNameExtensionFilter("Nooj Grammar (*.nog)", "nog");
        JFileChooser jFileChooser = new JFileChooser(defaultFile);
        jFileChooser.setDialogTitle("Open a grammar");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(filterGram);
        jFileChooser.setFileFilter(filterGram);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        int result = jFileChooser.showOpenDialog(this.frame);
        if (result == 0) {
            JComboBox combo = this.locateDialog.getNooJGrammarPathCombo();
            File selectedFile = jFileChooser.getSelectedFile();
            String filePath = selectedFile.getAbsolutePath();
            combo.setSelectedItem(filePath);
            combo.setPrototypeDisplayValue("XXX");
            combo.addItem(filePath);
            this.listOfFilesToBeSaved.add(filePath);
        }
    }

    private void enableGrammarComponents() {
        this.locateDialog.getSetButton().setEnabled(true);
        this.locateDialog.getSyntacticAnalysisCBox().setEnabled(true);
        this.locateDialog.getNooJGrammarPathCombo().setEnabled(true);
    }

    private void disableGrammarComponents() {
        this.locateDialog.getSetButton().setEnabled(false);
        this.locateDialog.getSyntacticAnalysisCBox().setEnabled(false);
        this.locateDialog.getNooJGrammarPathCombo().setEnabled(false);
    }

    private void enableIndexRadioButtons() {
        this.locateDialog.getRbShortestMatches().setEnabled(true);
        this.locateDialog.getRbAllIndexMatches().setEnabled(true);
        this.locateDialog.getRbLongestMatches().setEnabled(true);
    }

    private void disableIndexRadioButtons() {
        this.locateDialog.getRbShortestMatches().setEnabled(false);
        this.locateDialog.getRbAllIndexMatches().setEnabled(false);
        this.locateDialog.getRbLongestMatches().setEnabled(false);
    }
}

